package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * This class hold options together and selects the way how they should behave.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class DialogOptionList extends DialogComponent {

	public enum Mode {
		MULTI, SINGLE,
	}

	/** The mode how should the optionlist behave */
	protected Mode mode = Mode.SINGLE;
	protected List<DialogOption> options = new LinkedList<DialogOption>();

	public DialogOptionList() {
		super();
	}

	public DialogOptionList(String id) {
		super(id);
	}

	/**
	 * Adds a new option to the option list
	 * @param option
	 */
	public void addOption(DialogOption option) {
		options.add(option);
		option.setParent(this);
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		for (DialogOption option : options) {
			list.addAll(option.createItemCommands());
		}
		return list;
	}

	@Override
	public DialogComponent findComponent(String id) {
		DialogComponent dc = super.findComponent(id);
		if (dc != null) {
			return dc;
		}
		for (DialogComponent c: options) {
			dc = c.findComponent(id);
			if (dc != null) {
				return dc;
			}
		}
		return null;
	}
	
	public Mode getMode() {
		return mode;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("OPTIONLIST");
		myItem.setMode(mode.toString());
		return myItem;
	}

	public void setMode(Mode mode) {
		this.mode = mode;
	}

}
