package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialog;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialogListener;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasAction;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

public class DialogLayerContainer extends DialogComponent implements IHasAction {

	protected String action;
	protected List<DialogLayer> layers = new LinkedList<DialogLayer>();
	protected List<DialogLayer> dead = new LinkedList<DialogLayer>();
	protected List<IDialogListener> listeners = new LinkedList<IDialogListener>();
	protected Point2D viewport;

	public DialogLayerContainer() {
	}

	public DialogLayerContainer(String id) {
		super(id);
	}

	/**
	 * Adds a layer placed over the image
	 * 
	 * @param layer
	 */
	public void addLayer(DialogLayer layer) {
		layers.add(layer);
	}

	@Override
	public void addListener(IDialogListener listener) {
		listeners.add(listener);
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new ArrayList<DialogItem>();
		list.add(myItemCommand());
		for (DialogLayer layer: layers) {
			DialogItem item = layer.createItemCommand();
			item.setParent(getId());
			list.add(item);
		}
		for (DialogLayer layer: dead) {
			list.add(layer.createItemCommand());
		}
		dead.clear();
		return list;
	}

	@Override
	public void dialogCancelled(IDialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCancelled(dialog, data);
		}
	}

	@Override
	public void dialogCommand(IDialog dialog, String command,
			Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCommand(dialog, command, data);
		}
	}

	@Override
	public void dialogSubmitted(IDialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogSubmitted(dialog, data);
		}
	}

	public String getAction() {
		return action;
	}

	public Point2D getViewport() {
		return viewport;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("LAYERCONTAINER");
		myItem.setAction(action);
		myItem.setViewport(viewport);
		return myItem;
	}
	
	/**
	 * Removes a layer from the image
	 * 
	 * @param layer
	 */
	public void removeLayer(DialogLayer layer) {
		if (layer == null) {
			return;
		}
		if (layers.remove(layer)) {
			layer.setState(State.DEAD);
			dead.add(layer);
		}
	}

	public void removeListener(IDialogListener listener) {
		listeners.remove(listener);
	}
	
	public void setAction(String action) {
		this.action = action;
	}

	public void setViewport(Point2D viewport) {
		this.viewport = viewport;
	}

}
