package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.geom.Point2D;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

public abstract class DialogLayer extends DialogObject {

	protected Point2D shift;
	protected boolean visible = true;
		
	public DialogItem createItemCommand() {
		if (state == State.DELETED) {
			throw new IllegalStateException("This object is no longer alive.");
		}
		DialogItem myItem = new DialogItem();
		myItem.setId(getId());
		myItem.setShift(shift);
		myItem.setVisible(visible);
		switch (state) {
		case NEW:
			myItem.setEffect("ADD");
			setState(State.SHOWN);
			break;
		case SHOWN:
			myItem.setEffect("EDIT");
			break;
		case DEAD:
			myItem.setEffect("DELETE");
			setState(State.DELETED);
			break;
		}
		return myItem;
	}

	public Point2D getShift() {
		return shift;
	}

	public void setShift(Point2D shift) {
		this.shift = shift;
	}

	public boolean isVisible() {
		return visible;
	}

	public void setVisible(boolean visible) {
		this.visible = visible;
	}
}
