package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasColor;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasImage;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasScale;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasSourcePart;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

public class DialogImageLayer extends DialogLayer implements IHasImage, IHasColor, IHasScale, IHasSourcePart {
	protected String image;
	protected Dimension2D scale;
	protected Rectangle2D sourcePart;
	protected Color color;

	@Override
	public DialogItem createItemCommand() {
		DialogItem myItem = super.createItemCommand();
		myItem.setType("IMAGELAYER");
		myItem.setImage(image);
		myItem.setScale(scale);
		myItem.setImageColor(color);
		myItem.setSourcePart(sourcePart);
		return myItem;
	}
	
	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public Dimension2D getScale() {
		return scale;
	}

	public void setScale(Dimension2D scale) {
		this.scale = scale;
	}

	public Rectangle2D getSourcePart() {
		return sourcePart;
	}

	public void setSourcePart(Rectangle2D sourcePart) {
		this.sourcePart = sourcePart;
	}

	public void setColor(Color color) {
		this.color = color;		
	}
	
	public Color getColor() {
		return color;
	}
}
