package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasColor;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasImage;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasScale;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasSourcePart;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

public class DialogImage extends DialogLayerContainer implements IHasImage,
		IHasColor, IHasScale, IHasSourcePart {

	protected String image;
	protected Dimension2D scale;
	protected Rectangle2D sourcePart;
	protected Color color;

	public DialogImage() {
		super();
	}

	public DialogImage(String id) {
		super(id);
	}

	@Override
	public void addLayer(DialogLayer layer) {
		throw new UnsupportedOperationException("Image has fixed layer.");
	}

	@Override
	public void removeLayer(DialogLayer layer) {
		throw new UnsupportedOperationException("Image has fixed layer.");
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		return list;
	}

	public String getImage() {
		return image;
	}

	public Dimension2D getScale() {
		return scale;
	}

	public Rectangle2D getSourcePart() {
		return sourcePart;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("IMAGE");
		myItem.setImage(image);
		myItem.setSourcePart(sourcePart);
		myItem.setScale(scale);
		myItem.setImageColor(color);
		return myItem;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public void setScale(Dimension2D scale) {
		this.scale = scale;
	}

	public void setSourcePart(Rectangle2D sourcePart) {
		this.sourcePart = sourcePart;
	}

	public Color getColor() {
		return color;
	}

	public void setColor(Color color) {
		this.color = color;
	}
}
