package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialogComponent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Base of all dialog's components
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public abstract class DialogComponent extends DialogObject implements IDialogComponent {
	protected DialogComponent parent;
	protected Point2D position;
	protected Dimension2D size;
	protected boolean visible = true;
		
	public DialogComponent() {
		super();
	}
	
	public DialogComponent(String id) {
		super(id);
	}

	/**
	 * Creates a list of DialogItem
	 * 
	 * @return
	 */
	public abstract List<DialogItem> createItemCommands();

	/**
	 * Tries to find in children components a component with specified id
	 * 
	 * @param id
	 * @return
	 */
	public DialogComponent findComponent(String id) {
		if (id.equals(getId())) {
			return this;
		}
		return null;
	}
	
	public DialogComponent getParent() {
		return parent;
	}

	public Point2D getPosition() {
		return position;
	}

	public Dimension2D getSize() {
		return size;
	}

	public boolean isVisible() {
		return visible;
	}

	/**
	 * Creates a DialogItem command belonging to this component
	 * 
	 * @return
	 */
	protected DialogItem myItemCommand() {
		if (state == State.DELETED) {
			throw new IllegalStateException("This object is no longer alive.");
		}
		DialogItem myItem = new DialogItem();
		myItem.setId(getId());
		myItem.setSize(size);
		myItem.setPosition(position);
		myItem.setVisible(visible);
		switch (state) {
		case NEW:
			myItem.setEffect("ADD");
			setState(State.SHOWN);
			break;
		case SHOWN:
			myItem.setEffect("EDIT");
			break;
		case DEAD:
			myItem.setEffect("DELETE");
			setState(State.DELETED);
			break;
		}
		if (parent != null) {
			myItem.setParent(parent.getId());
		}
		return myItem;
	}

	@Override
	public void setParent(IDialogComponent parent) {
		this.parent = (DialogComponent)parent;
	}

	public void setPosition(Point2D position) {
		this.position = position;
	}

	public void setSize(Dimension2D size) {
		this.size = size;
	}

	public void setVisible(boolean visible) {
		this.visible = visible;
	}
}
