package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialog;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialogListener;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasAction;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasImage;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IHasText;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Class describing the button on dialog.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class DialogButton extends DialogFramedComponent implements IHasAction,
		IHasText, IHasImage {

	/** Action performed when the button is pressed */
	protected String action;
	protected List<IDialogListener> listeners = new LinkedList<IDialogListener>();
	/** Image displayed left from the text */
	protected String image;
	/** Colour of the image */
	protected Color imageColor;
	/** Text written on the button */
	protected String text;
	/** Colour of the text */
	protected Color textColor;
	
	protected TextSize textSize = TextSize.DEFAULT;

	public DialogButton() {
		super();
	}

	public DialogButton(String id) {
		super(id);
	}

	@Override
	public void addListener(IDialogListener listener) {
		listeners.add(listener);
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		return list;
	}

	@Override
	public void dialogCancelled(IDialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCancelled(dialog, data);
		}
	}

	@Override
	public void dialogCommand(IDialog dialog, String command,
			Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCommand(dialog, command, data);
		}
	}

	@Override
	public void dialogSubmitted(IDialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogSubmitted(dialog, data);
		}
	}

	public String getAction() {
		return action;
	}

	public String getText() {
		return text;
	}

	public Color getTextColor() {
		return textColor;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("BUTTON");
		myItem.setAction(action);
		myItem.setText(text);
		myItem.setTextColor(textColor);
		myItem.setImage(image);
		myItem.setImageColor(imageColor);
		switch (textSize) {
		case SMALL:
			myItem.setTextSize("SMALL");
			break;
		case MEDIUM:
			myItem.setTextSize("MEDIUM");
			break;
		case BIG:
			myItem.setTextSize("BIG");
			break;
		//case DEFAULT: don't set it
		}
		return myItem;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setTextColor(Color textColor) {
		this.textColor = textColor;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public Color getImageColor() {
		return imageColor;
	}

	public void setImageColor(Color imageColor) {
		this.imageColor = imageColor;
	}

	public TextSize getTextSize() {
		return textSize;
	}

	public void setTextSize(TextSize textSize) {
		this.textSize = textSize;
	}

}
