package cz.cuni.amis.pogamut.ut2004.server.commands;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.server.commands.IBotControl;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.CommandBot;
import cz.cuni.amis.pogamut.ut2004.server.AbstractUT2004Server;

public class BotControl extends ServerCommands implements IBotControl {

	public BotControl(AbstractUT2004Server server, Logger log) {
		super(server, log);
	}

	@Override
	public void transportBotTo(String botName, Location location, Rotation rotation) {
		CommandBot commandBot = new CommandBot();
		commandBot.setBot(botName);
		commandBot.setCommand("TRANSPORT");
		commandBot.setLocation(location);
		commandBot.setRotation(rotation);
		server.getAct().act(commandBot);
	}

}
