package cz.cuni.amis.pogamut.base.server.commands.dialog;

import java.util.Map;

/**
 * Interface for dialog components who can raise some command. You can register
 * a listener on such component. I
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface IHasAction {

	public void setAction(String action);

	public String getAction();

	/**
	 * Calls corresponding method in IDialogListener listener
	 * 
	 * @param dialog
	 * @param data
	 */
	public void dialogCancelled(IDialog dialog, Map<String, String> data);

	/**
	 * Calls corresponding method in IDialogListener listener
	 * 
	 * @param dialog
	 * @param command
	 * @param data
	 */
	public void dialogCommand(IDialog dialog, String command,
			Map<String, String> data);

	/**
	 * Calls corresponding method in IDialogListener listener
	 * 
	 * @param dialog
	 * @param data
	 */
	public void dialogSubmitted(IDialog dialog, Map<String, String> data);

	/**
	 * Adds an listener (callback) to the component
	 * 
	 * @param listener
	 */
	public void addListener(IDialogListener listener);

}
