package cz.cuni.amis.pogamut.base.server.commands.dialog;

import java.util.Map;


/**
 * Callback interface for something that intitiates a dialog
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public interface IDialogListener {
	
	/**
	 * Called when user cancels the dialog
	 * 
	 * @param data
	 *            Data that user filled into the dialog
	 */
	public void dialogCancelled(IDialog dialog, Map<String, String> data);

	/**
	 * Called when user triggers some other action on the dialog
	 * 
	 * @param data
	 *            Data that user filled into the dialog
	 */
	public void dialogCommand(IDialog dialog, String command, Map<String, String> data);

	/**
	 * Called when user submits the dialog
	 * 
	 * @param data
	 *            Data that user filled into the dialog
	 */
	public void dialogSubmitted(IDialog dialog, Map<String, String> data);
}
