package cz.cuni.amis.pogamut.base.server.commands.dialog;

import java.util.Map;

import cz.cuni.amis.pogamut.base.server.commands.IPlayerCommunication;

public interface IDialog {
	void addListener(IDialogListener listener);

	public Map<String, String> getData();
	
	public String getId();
	
	public String getLastCommand();

	public IDialogPanel getMainPanel();

	public IPlayerCommunication getPlayerCommunication();
	
	public String getTargetPlayer();

	public boolean isDeployed();

	public boolean isDisplayed();

	public boolean isFinished();
	
	public boolean processCommand(String sourceId, String command);

	public void setData(String data);

	public void setDeployed();

	public void setDisplayed(boolean displayed);

	public void setMainPanel(IDialogPanel panel);

	public void setPlayerCommunication(IPlayerCommunication playerCommunication);
}
