package cz.cuni.amis.pogamut.base.server.commands;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;

public interface IPlayerControl {
	/**
	 * Moves player to specified location, while looking to specified place
	 * 
	 * @param playerName
	 * @param whereToGo
	 * @param whereToLook
	 * @param shouldWalk
	 */
	public void moveTo(String playerName, Location whereToGo,
			Location whereToLook, boolean shouldWalk);

	/**
	 * Turns player to specified location and lets him run there (on straight
	 * line).
	 * 
	 * @param playerName
	 * @param location
	 * @param shouldWalk
	 */
	public void runTo(String playerName, Location location);

	/**
	 * Moves the player in a non-colliding way to the specified location.
	 * 
	 * @param playerName
	 * @param location
	 * @param shouldWalk
	 */
	public void safeMoveTo(String playerName, Location location, boolean shouldWalk);
	
	/**
	 * Removes or returns control to player.
	 * 
	 * @param playerName
	 * @param control
	 */
	public void setPlayerControl(String playerName, boolean control);
	
	/**
	 * Sets player's location to the specified one, without moving 
	 * 
	 * @param playerName
	 * @param location
	 */
	public void transportTo(String playerName, Location location, Rotation rotation);
	
	/**
	 * Turns player towards specified location
	 * 
	 * @param playerName
	 * @param location
	 */
	public void turnTo(String playerName, Location location);

	/**
	 * Turns player according to specified direction
	 * 
	 * @param playerName
	 * @param rotation
	 *            Direction of sight
	 */
	public void turnTo(String playerName, Rotation rotation);

	/**
	 * Turns player to specified location and lets him walk there (on straight
	 * line).
	 * 
	 * @param playerName
	 * @param location
	 * @param shouldWalk
	 */
	public void walkTo(String playerName, Location location);
}
