package cz.cuni.amis.pogamut.base.server.commands;

import java.awt.Color;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialog;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialogComponent;

public interface IPlayerCommunication {
	/**
	 * Adds a listener listening to player's key events
	 * 
	 * @param playerName
	 * @param listener
	 */
	public void addKeyEventListener(String playerName,
			IKeyEventListener listener);

	/**
	 * Factory method that should return new Dialog
	 * 
	 * @param name
	 * @return
	 */
	public IDialog createDialog(String name);
	
	/**
	 * Plays a sound to the player
	 * 
	 * @param playerName
	 *            Name of the affected player
	 * @param sound
	 *            Unreal reference to the sound, e.g.
	 *            "MyPackage.MySoundGroup.MySound". The sound has to be already
	 *            in some .uax file.
	 */
	public void playSound(String playerName, String sound);

	/**
	 * Hides the dialog
	 * 
	 * @param dialog
	 */
	public void destroyDialog(IDialog dialog);

	/**
	 * Removes a listener listening to player's key events
	 * 
	 * @param playerName
	 * @param listener
	 */
	public void removeKeyEventListener(String playerName,
			IKeyEventListener listener);

	/**
	 * Removes a text from player's screen
	 * 
	 * @param playerName
	 *            Name of the affected player
	 * @param message
	 *            Text of message that should disappear
	 */
	public void removeText(String playerName, String message);

	/**
	 * Displays a dialog on player's screen and associates the dialog with this
	 * playerCommunication.
	 * 
	 * @param dialog
	 */
	public void showDialog(IDialog dialog);

	/**
	 * Displays a text on top of screen in white color. The text will persist
	 * there until removed.
	 * 
	 * @param playerName
	 *            Name of the player who should see the message
	 * @param message
	 *            The message displayed
	 */
	public void showText(String playerName, String message);

	/**
	 * Displays a text on top of screen in white color.
	 * 
	 * @param playerName
	 *            Name of the player who should see the message
	 * @param message
	 *            The message displayed
	 * @param timeout
	 *            Amount of time (in seconds) after which the text disappears.
	 *            Zero means that the text will not disappear until removed.
	 */
	public void showText(String playerName, String message, double timeout);

	/**
	 * Displays a text on top of screen
	 * 
	 * @param playerName
	 *            Name of the player who should see the message
	 * @param message
	 *            The message displayed
	 * @param timeout
	 *            Amount of time (in seconds) after which the text disappears.
	 *            Zero means that the text will not disappear until removed.
	 * @param color
	 *            Color in which will be the text printed
	 */
	public void showText(String playerName, String message, double timeout,
			Color color);

	/**
	 * Updates currently displayed dialog
	 * 
	 * @param dialog
	 */
	public void updateDialog(IDialog dialog);

	/**
	 * Updates specific component of some displayed dialog
	 * 
	 * @param dialog
	 * @param component
	 */
	public void updateDialogComponent(IDialog dialog, IDialogComponent component);

	/**
	 * Temporarily hides a dialog on player's screen
	 * 
	 * @param dialog
	 */
	void hideDialog(IDialog dialog);

	/**
	 * Plays a sound to the player in an infinite loop
	 * 
	 * @param playerName
	 *            Name of the affected player
	 * @param sound
	 *            Unreal reference to the sound, e.g.
	 *            "MyPackage.MySoundGroup.MySound". The sound has to be already
	 *            in some .uax file.
	 */
	void playSoundInLoop(String playerName, String sound);

	/**
	 * Stops a sound played in an infinite loop
	 * 
	 * @param playerName
	 */
	void stopSoundLoop(String playerName);
}
