package cz.cuni.amis.pogamut.base.server.commands;

/**
 * Interface for those who want to listen on key events, using
 * PlayerCommunication module.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface IKeyEventListener {

	/**
	 * Called when the user presses some key
	 * 
	 * @param key
	 */
	void keyPressed(String key);

	/**
	 * Called when the user releases some key
	 * 
	 * @param key
	 */
	void keyReleased(String key);

	/**
	 * Called when the user holds some key
	 * 
	 * @param key
	 */
	void keyHeld(String key);

}
