package cz.cuni.amis.pogamut.edu.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/**
 * The wizard generating new main Java file for the Scenario.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class NewESMainWizard extends Wizard implements INewWizard {

	private IStructuredSelection selection;
	private NewESMainPage newFilePage;

	public NewESMainWizard() {
		setWindowTitle("New EduScenarion main Java file");
	}

	@Override
	public void addPages() {
		newFilePage = new NewESMainPage(selection);
		addPage(newFilePage);
	}

	@Override
	public boolean performFinish() {
		StringBuilder initContent = new StringBuilder();
		initContent.append("package mypackage;\n\n");
		initContent.append("import java.text.SimpleDateFormat;\n");
		initContent.append("import java.util.Date;\n");
		initContent.append("import cz.cuni.amis.pogamut.edu.Scenario;\n");
		initContent
					.append("import cz.cuni.amis.pogamut.edu.ut2004.UT2004Scenario;\n");
		initContent.append("public class Main {\n");
		initContent.append("\tpublic static void main(String[] args) {\n");
		initContent
					.append("\t\tScenario scenario = new UT2004Scenario(\"MyScenario.xml\");\n");
		initContent.append("\t\tscenario.setState(Scenario.State.READY);\n");
		initContent.append("\t\tscenario.run();\n");
		initContent
					.append("\t\tString dateTime = new SimpleDateFormat(\"ddMMyy_hhmmss\").format(new Date());\n");
		initContent
					.append("\t\tscenario.storeReports(\"reports\" + dateTime + \".txt\");\n");
		initContent
					.append("\t\tscenario.storeScores(\"scores\" + dateTime + \".txt\");\n");
		initContent.append("\t\tSystem.exit(0);\n");
		initContent.append("\t}\n}\n");
		newFilePage.setContent(initContent.toString());
		IFile file = newFilePage.createNewFile();
		if (file != null) {
			return true;
		} else {
			return false;
		}
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}
}
