package cz.cuni.amis.pogamut.edu.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

/**
 * The new file page in the wizard generating a new main Java class.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class NewESMainPage extends WizardNewFileCreationPage {

	protected String content;

	public NewESMainPage(IStructuredSelection selection) {
		super("New EduScenario main Java file", selection);
		setTitle("New EduScenario main Java file");
		setDescription("Creates a new main Java file for Educational Scenarios.");
		setFileExtension("java");
	}

	@Override
	protected InputStream getInitialContents() {
		return new ByteArrayInputStream(content.getBytes());
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
}
