package cz.cuni.amis.pogamut.edu.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/**
 * The wizard generating the configuration file for ES.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class NewESConfigWizard extends Wizard implements INewWizard {

	private IStructuredSelection selection;
	private NewESConfigPage newFilePage;

	public NewESConfigWizard() {
		setWindowTitle("New EduScenarios config file");
	}

	@Override
	public void addPages() {
		newFilePage = new NewESConfigPage(selection);
		addPage(newFilePage);
	}

	@Override
	public boolean performFinish() {
		StringBuilder initContent = new StringBuilder();
		initContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
		initContent
					.append("<!-- Here you can specify the language of the scenario. -->\n");
		initContent.append("<scenario lang=\"english\">\n\n");
		initContent
					.append("\t<!-- Set the minimal number of players that can perform the scenario (usually 1). -->");
		initContent.append("\t<players min=\"1\"/>\n\n");
		initContent
					.append("\t<!-- The list of DSLR rule files using the specified DSL. You have to specify the paths. -->\n");
		initContent.append("\t<rules dsl=\"edu-english.dsl\">\n");
		initContent.append("\t\t<package src=\"MyRulesFile.dslr\"/>\n");
		initContent.append("\t</rules>\n\n");
		initContent.append("\t<!-- The structure of acts -->\n");
		initContent.append("\t<scenes>\n");
		initContent.append("\t\t<act id=\"parts\">\n");
		initContent.append("\t\t\t<act id=\"act one\"></act>\n");
		initContent.append("\t\t\t<act id=\"act two\"></act>\n");
		initContent.append("\t\t</act>\n");
		initContent.append("\t\t<act id=\"exceptions\">\n");
		initContent.append("\t\t\t<act id=\"no exception\"></act>\n");
		initContent.append("\t\t\t<act id=\"in exception\"></act>\n");
		initContent.append("\t\t</act>\n");
		initContent.append("\t</scenes>\n\n");
		initContent.append("\t<!-- List of map files -->\n");
		initContent.append("\t<maps>\n");
		initContent.append("\t\t<map src=\"citymap.xml\"/>\n");
		initContent.append("\t</maps>\n\n");
		initContent.append("</scenario>\n");
		newFilePage.setContent(initContent.toString());
		IFile file = newFilePage.createNewFile();
		if (file != null) {
			return true;
		} else {
			return false;
		}
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}
}
