package cz.cuni.amis.pogamut.edu.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

/**
 * The new file page for configuration file generating wizard.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class NewESConfigPage extends WizardNewFileCreationPage {

	protected String content;

	public NewESConfigPage(IStructuredSelection selection) {
		super("New EduScenario configuration file", selection);
		setTitle("New EduScenario configuration file");
		setDescription("Creates a new configuration file for Educational Scenarios.");
		setFileExtension("xml");
	}

	@Override
	protected InputStream getInitialContents() {
		return new ByteArrayInputStream(content.getBytes());
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
}
