package cz.cuni.amis.pogamut.edu.utils;

/**
 * Some objects should have their name. This name should remain the same for the
 * most of time, but in rare occasions it can be changed. That's why it should
 * also store the previous name (when the object is registered in some data
 * structure with the name as key).
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface INamed {

	/**
	 * 
	 * @return name of this object.
	 */
	public String getName();

	/**
	 * 
	 * @return name of this object before previous setName(...) call
	 */
	public String getPreviousName();

	/**
	 * Sets the name for this object
	 * 
	 * @param name
	 */
	public void setName(String name);
}
