package cz.cuni.amis.pogamut.edu.utils;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/**
 * Table of common used colours and conversion from the RGB to string and back.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class ColorTable {
	protected static Map<Color, String> color2name = new HashMap<Color, String>();
	protected static Map<String, Color> name2color = new HashMap<String, Color>();

	static {
		add("black", Color.black);
		add("white", Color.white);
		add("red", Color.red);
		add("green", Color.green);
		add("blue", Color.blue);
	}

	public static void add(String name, Color color) {
		color2name.put(color, name);
		name2color.put(name, color);
	}

	public static String getNameFor(Color color) {
		String name = color2name.get(color);
		if (name == null) {
			StringBuilder sb = new StringBuilder();
			sb.append("[r=");
			sb.append(color.getRed());
			sb.append(",g=");
			sb.append(color.getGreen());
			sb.append(",b=");
			sb.append(color.getBlue());
			sb.append("]");
			return sb.toString();
		} else {
			return name;
		}
	}

	public static Color getColorFor(String name) {
		if (name == null) {
			return Color.BLACK;
		}
		Color color = name2color.get(name);
		if (color == null) {
			int r, g, b;
			String[] rgb = name.split(",");
			r = Integer.valueOf(rgb[0].replaceAll("[^\\d]", ""));
			g = Integer.valueOf(rgb[1].replaceAll("[^\\d]", ""));
			b = Integer.valueOf(rgb[2].replaceAll("[^\\d]", ""));
			return new Color(r, g, b);
		} else {
			return color;
		}
	}
}
