package cz.cuni.amis.pogamut.edu.utils;

/**
 * Translates cardinal direction between enums, Rotations, and strings
 * with human names.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class CardinalDirections {

	public enum Direction {
		NONE, NORTH, NORTHEAST, EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST
	}

	public static final Direction angle65536ToDirection(double angle) {
		if (angle < 4096) {
			return Direction.EAST;
		} else if (angle < 12288) {
			return Direction.SOUTHEAST;
		} else if (angle < 20480) {
			return Direction.SOUTH;
		} else if (angle < 28672) {
			return Direction.SOUTHWEST;
		} else if (angle < 36864) {
			return Direction.WEST;
		} else if (angle < 45056) {
			return Direction.NORTHWEST;
		} else if (angle < 53248) {
			return Direction.NORTH;
		} else if (angle < 61440) {
			return Direction.NORTHEAST;
		} else {
			return Direction.NONE;
		}
	}

	public static final double directionToAngle65536(Direction direction) {
		switch (direction) {
		case EAST:
			return 0;
		case SOUTHEAST:
			return 8192;
		case SOUTH:
			return 16386;
		case SOUTHWEST:
			return 24567;
		case WEST:
			return 32768;
		case NORTHWEST:
			return 40960;
		case NORTH:
			return 49152;
		case NORTHEAST:
			return 57344;
		case NONE:
		default:
			return -1;
		}
	}

	public static final double nameToAngle65536(String name) {
		return directionToAngle65536(nameToDirection(name));
	}

	public static final Direction nameToDirection(String direction) {
		return Direction.valueOf(direction.toUpperCase());
	}
}
