package cz.cuni.amis.pogamut.edu.utils;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;

/**
 * Implements the rescale(Location) method as a combination of rescaleX, rescaleY and rescaleZ.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public abstract class AbstractRescaler implements IRescaler {

	@Override
	public Location rescale(Location location) {
		return new Location(rescaleX(location.getX()), rescaleY(location.getY()), rescaleZ(location.getZ()));
	}
}
