package cz.cuni.amis.pogamut.edu.ut2004.puppetbot;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.communication.commands.CommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.commands.SimpleLocomotion;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;

/**
 * The internal logic is adapted to plain execution of commands. These are
 * exposed through public interface - the SimpleLocomotion and AgentInfo
 * modules have public getter methods. Also the method order(...) is public.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class PuppetBot extends SyncUT2004Bot<UT2004SyncLockableWorldView> {

	protected String name;
	protected SimpleLocomotion simpleLocomotion;
	protected AgentInfo agentInfo;

	@Inject
	public PuppetBot(String name, AgentLogger logger,
			UT2004SyncLockableWorldView worldView, CommandSerializer body) {
		super(logger, worldView, body);
		setName(name);
		simpleLocomotion = new SimpleLocomotion(this, logger.platform());
		agentInfo = new AgentInfo(worldView, null, logger.platform());
	}

	public AgentInfo getAgentInfo() {
		return agentInfo;
	}

	public SimpleLocomotion getLocomotion() {
		return simpleLocomotion;
	}

	/**
	 * Switches the bot's walk/run state or orders him to jump.
	 * @param order
	 */
	public void order(String order) {
		if (order.equalsIgnoreCase("walk")) {
			simpleLocomotion.setWalk();
		} else if (order.equalsIgnoreCase("run")) {
			simpleLocomotion.setRun();
		} else if (order.equalsIgnoreCase("jump")) {
			simpleLocomotion.jump();
		} else
			throw new IllegalArgumentException("Unknown order!");
	}

	@Override
	protected void botInitialized(ConfigChange config, InitedMessage init) {
	}

	@Override
	protected void botKilled(BotKilled event) {
	}

	@Override
	protected Initialize createInitializeCommand() {
		return new Initialize().setName(getName()).setClassName(
			"GBScenario.ExampleBoy");
	}

	@Override
	protected void doLogic() throws PogamutException {
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	protected void postPrepareBot(GameInfo info) {
	}

	@Override
	protected void prePrepareBot() {
	}

	public void setName(String name) {
		this.name = name;
	}

}