package cz.cuni.amis.pogamut.edu.ut2004.dialogs;

import java.util.Map;

import org.drools.WorkingMemory;

import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialog;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialogListener;
import cz.cuni.amis.pogamut.edu.drools.IFact;
import cz.cuni.amis.pogamut.edu.drools.SimpleFactDelegate;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.Dialog;

public class SyncDialog extends Dialog implements IFact {
	protected SimpleFactDelegate factDelegate;
	
	public SyncDialog(String name) {
		super(name);
		factDelegate = new SimpleFactDelegate(this);
		addListener(new IDialogListener() {

			@Override
			public void dialogCancelled(IDialog dialog, Map<String, String> data) {
				factDelegate.update();
			}

			@Override
			public void dialogCommand(IDialog dialog, String command,
					Map<String, String> data) {
				factDelegate.update();
			}

			@Override
			public void dialogSubmitted(IDialog dialog, Map<String, String> data) {
				factDelegate.update();
			}
			
		});
	}
	
	@Override
	public void insertTo(WorkingMemory workingMemory) {
		factDelegate.insertTo(workingMemory);
	}

	@Override
	public void retractFrom(WorkingMemory workingMemory) {
		factDelegate.retractFrom(workingMemory);
	}

	@Override
	public void update() {
		factDelegate.update();
	}
	
	@Override
	public boolean isInserted() {
		return factDelegate.isInserted();
	}
}
