package cz.cuni.amis.pogamut.edu.ut2004.dialogs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.drools.WorkingMemory;

import cz.cuni.amis.pogamut.base.server.commands.IPlayerCommunication;
import cz.cuni.amis.pogamut.base.server.commands.dialog.DialogListenerAdapter;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialog;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.agent.Agent;
import cz.cuni.amis.pogamut.edu.agent.Player;
import cz.cuni.amis.pogamut.edu.drools.IFact;
import cz.cuni.amis.pogamut.edu.drools.SimpleFactDelegate;
import cz.cuni.amis.pogamut.edu.map.MapData;
import cz.cuni.amis.pogamut.edu.map.marks.IMark;
import cz.cuni.amis.pogamut.edu.map.marks.POI;
import cz.cuni.amis.pogamut.edu.map.marks.Path;
import cz.cuni.amis.pogamut.edu.ut2004.UT2004Scenario;
import cz.cuni.amis.pogamut.edu.ut2004.agent.UT2004Player;
import cz.cuni.amis.pogamut.edu.utils.ICoordsTransformer;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.Dialog;
import cz.cuni.amis.utils.Dimension2D_Double;

/**
 * The dialog with map (as background), POIs and paths. There can be also
 * players' positions selected. The dialog can be in selection mode where the
 * user clicks on some spot on the map and then confirms his choice.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class MapDialog extends Dialog implements IFact {

	public static interface IAgentDecorator {
		public Color getColor(Agent agent);

		public String getSymbol(Agent agent);
	}

	public final static IAgentDecorator DEFAULT_DECORATOR = new IAgentDecorator() {

		@Override
		public Color getColor(Agent agent) {
			return Color.BLUE;
		}

		@Override
		public String getSymbol(Agent agent) {
			return "EducationalScenarios.Symbols.Player";
		}

	};

	protected ICoordsTransformer transformer = new ICoordsTransformer() {

		private double scale;
		private double originX;
		private double originY;

		@Override
		public Point2D location2point(Location l) {
			return new Point2D.Double((l.x - originX) / scale, (l.y - originY)
					/ scale);
		}

		@Override
		public Location point2location(Point2D p) {
			return new Location(p.getX() * scale + originX, p.getY() * scale
					+ originY);
		}

		@Override
		public void setParams(double scale, double originX, double originY) {
			this.scale = scale;
			this.originX = originX;
			this.originY = originY;
		}
	};

	protected SimpleFactDelegate factDelegate = new SimpleFactDelegate(this);
	protected UT2004Player player;

	public MapDialog(UT2004Player player, final UT2004Scenario scenario,
			MapData data) {
		this.player = player;
		MapDialogComponent mdc = new MapDialogComponent();
		mdc.setBgColor(Color.GRAY);
		mdc.setSize(new Dimension2D_Double(0.9, 0.9));
		mdc.setPosition(new Point2D.Double(0.05, 0.05));
		transformer.setParams(data.getScale(), data.getOriginX(),
			data.getOriginY());
		mdc.addSelectionListener(new DialogListenerAdapter() {
			@Override
			public void dialogCommand(IDialog dialog, String command,
					Map<String, String> data) {
				if (((MapDialogComponent) getMainPanel()).hasSelectionEnabled()) {
					update();
				}
			}
		});
		mdc.setMap(data.getPlanUnrealId());
		for (IMark mark : data.getMarks()) {
			if (mark instanceof POI) {
				mdc.addPOI((POI) mark, transformer);
			} else if (mark instanceof Path) {
				mdc.addPath((Path) mark, transformer);
			}
		}
		setMainPanel(mdc);

		(new Thread() {// this keeps the dialog synchronized
			@Override
			public void run() {
				List<Agent> agentList = new ArrayList<Agent>();
				while (true) {
					if (isDeployed() && isDisplayed()) {
						MapDialogComponent mdc = ((MapDialogComponent) getMainPanel());
						agentList.clear();
						for (Agent p : scenario.getAgentList()) {
							if (MapDialog.this.player.isAgentAllowed(p)) {
								agentList.add(p);
							}
						}
						if (mdc.updateAgents(agentList, DEFAULT_DECORATOR,
							transformer)
								|| mdc.updateMarksVisiblity()) {
							playerCommunication.updateDialog(MapDialog.this);
						}
					}
					try {
						sleep(1000);
					} catch (InterruptedException e) {
					}
				}
			}
		}).start();
	}

	public void show(Player player, IPlayerCommunication playerCommunication) {
		setTargetPlayer(player.getInGameName());
		playerCommunication.showDialog(this);
		update();
	}

	public void hide() {
		if (this.isDisplayed()) {
			playerCommunication.hideDialog(this);
			update();
		}
	}

	public boolean isSelectionEnabled() {
		return ((MapDialogComponent) getMainPanel()).hasSelectionEnabled();
	}

	public void setSelectionEnabled(boolean enable) {
		((MapDialogComponent) getMainPanel()).setSelectionEnabled(enable, this);
	}

	public Location getSelectedPosition() {
		Point2D lastClick = ((MapDialogComponent) getMainPanel())
																	.getLastClick();
		if (lastClick == null) {
			return null;
		} else {
			return transformer.point2location(lastClick);
		}
	}

	@Override
	public void insertTo(WorkingMemory workingMemory) {
		factDelegate.insertTo(workingMemory);
	}

	@Override
	public void retractFrom(WorkingMemory workingMemory) {
		factDelegate.retractFrom(workingMemory);
	}

	@Override
	public void update() {
		factDelegate.update();
	}

	@Override
	public boolean isInserted() {
		return factDelegate.isInserted();
	}
}
