package cz.cuni.amis.pogamut.edu.ut2004.dialogs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;

import org.drools.WorkingMemory;

import cz.cuni.amis.pogamut.base.server.commands.IPlayerCommunication;
import cz.cuni.amis.pogamut.base.server.commands.dialog.DialogListenerAdapter;
import cz.cuni.amis.pogamut.base.server.commands.dialog.IDialog;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.edu.agent.Player;
import cz.cuni.amis.pogamut.edu.drools.IFact;
import cz.cuni.amis.pogamut.edu.drools.SimpleFactDelegate;
import cz.cuni.amis.pogamut.edu.utils.CardinalDirections;
import cz.cuni.amis.pogamut.edu.utils.CardinalDirections.Direction;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.Dialog;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogImageLayer;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogLayerContainer;
import cz.cuni.amis.pogamut.ut2004.server.commands.dialog.DialogPanel;
import cz.cuni.amis.utils.Dimension2D_Double;

/**
 * The dialog displaying compass rose. Each of the directions can be highlighted
 * and the user can click on them (the dialog updates the direction member).
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class CardinalDirectionsDialog extends Dialog implements IFact {

	/**
	 * The listener updating the direction member.
	 * 
	 * @author Radim Vansa <radim.vansa@matfyz.cz>
	 * 
	 */
	protected class ClickListener extends DialogListenerAdapter {
		@Override
		public void dialogCommand(IDialog dialog, String command,
				Map<String, String> data) {
			double clickX = Double.parseDouble(data.get(directions.getId()
					+ ".ClickX"));
			double clickY = Double.parseDouble(data.get(directions.getId()
					+ ".ClickY"));
			double width = Double.parseDouble(data.get(directions.getId()
					+ ".DisplayedWidth"));
			double height = Double.parseDouble(data.get(directions.getId()
					+ ".DisplayedHeight"));
			clickX = clickX - width / 2;
			clickY = clickY - height / 2;
			if (clickX * clickX + clickY * clickY > width * width / 16) {
				/*
				 * FOR SOME REASON ON TRAININGDAY WORKS THIS... if (clickY < 0) {
				 * double angle = Math.atan(-clickX/clickY); if (angle <
				 * -3*Math.PI/8) { direction = new Rotation(0, 0, 0); } else if
				 * (angle < -Math.PI/8) { direction = new Rotation(0, 8192, 0); }
				 * else if (angle < Math.PI/8) { direction = new Rotation(0,
				 * 16384, 0); } else if (angle < 3*Math.PI/8) { direction = new
				 * Rotation(0, 24576, 0); } else { direction = new Rotation(0,
				 * 32768, 0); } } else if (clickY > 0) { double angle =
				 * Math.atan(clickX/clickY); if (angle < -3*Math.PI/8) {
				 * direction = new Rotation(0, 0, 0); } else if (angle <
				 * -Math.PI/8) { direction = new Rotation(0, 57344, 0); } else
				 * if (angle < Math.PI/8) { direction = new Rotation(0, 49152,
				 * 0); } else if (angle < 3*Math.PI/8) { direction = new
				 * Rotation(0, 40960, 0); } else { direction = new Rotation(0,
				 * 32768, 0); } } else { if (clickX < 0) { direction = new
				 * Rotation(0, 0, 0); } else { direction = new Rotation(0,
				 * 32768, 0); } }
				 */
				if (clickY < 0) {
					double angle = Math.atan(-clickX / clickY);
					if (angle < -3 * Math.PI / 8) {
						direction = new Rotation(0, 32768, 0);
					} else if (angle < -Math.PI / 8) {
						direction = new Rotation(0, 40960, 0);
					} else if (angle < Math.PI / 8) {
						direction = new Rotation(0, 49152, 0);
					} else if (angle < 3 * Math.PI / 8) {
						direction = new Rotation(0, 57344, 0);
					} else {
						direction = new Rotation(0, 0, 0);
					}
				} else if (clickY > 0) {
					double angle = Math.atan(clickX / clickY);
					if (angle < -3 * Math.PI / 8) {
						direction = new Rotation(0, 32768, 0);
					} else if (angle < -Math.PI / 8) {
						direction = new Rotation(0, 24576, 0);
					} else if (angle < Math.PI / 8) {
						direction = new Rotation(0, 16384, 0);
					} else if (angle < 3 * Math.PI / 8) {
						direction = new Rotation(0, 8192, 0);
					} else {
						direction = new Rotation(0, 0, 0);
					}
				} else {
					if (clickX > 0) {
						direction = new Rotation(0, 0, 0);
					} else {
						direction = new Rotation(0, 32768, 0);
					}
				}
				update();
			}
		}
	}

	protected final static String OTHER_PACKAGE = "EducationalScenarios.Other";
	protected DialogImageLayer cds = new DialogImageLayer();

	protected Rotation direction = null;
	protected DialogLayerContainer directions = new DialogLayerContainer();
	protected SimpleFactDelegate factDelegate = new SimpleFactDelegate(this);
	protected DialogImageLayer he = new DialogImageLayer();
	protected DialogImageLayer hn = new DialogImageLayer();
	protected DialogImageLayer hne = new DialogImageLayer();
	protected DialogImageLayer hnw = new DialogImageLayer();
	protected DialogImageLayer hs = new DialogImageLayer();
	protected DialogImageLayer hse = new DialogImageLayer();
	protected DialogImageLayer hsw = new DialogImageLayer();

	protected DialogImageLayer hw = new DialogImageLayer();

	public CardinalDirectionsDialog() {
		super();
		init();
	}

	public CardinalDirectionsDialog(String id) {
		super(id);
		init();
	}

	public void clearHighlighting() {
		hn.setVisible(false);
		hne.setVisible(false);
		he.setVisible(false);
		hse.setVisible(false);
		hs.setVisible(false);
		hsw.setVisible(false);
		hw.setVisible(false);
		hnw.setVisible(false);
		playerCommunication.updateDialogComponent(this, directions);
	}

	public Rotation getSelectedDirection() {
		return direction;
	}

	public void hide() {
		direction = null;
		playerCommunication.hideDialog(this);
		update();
	}

	public void highlight(Direction direction) {
		switch (direction) {
		case NORTH:
			hn.setVisible(true);
			break;
		case NORTHEAST:
			hne.setVisible(true);
			break;
		case EAST:
			he.setVisible(true);
			break;
		case SOUTHEAST:
			hse.setVisible(true);
			break;
		case SOUTH:
			hs.setVisible(true);
			break;
		case SOUTHWEST:
			hsw.setVisible(true);
			break;
		case WEST:
			hw.setVisible(true);
			break;
		case NORTHWEST:
			hnw.setVisible(true);
			break;
		case NONE:
			clearHighlighting();
			break;
		}
		playerCommunication.updateDialogComponent(this, directions);
	}

	public void highlight(Rotation rotation) {
		highlight(CardinalDirections.angle65536ToDirection(rotation.getRoll()));
		playerCommunication.updateDialogComponent(this, directions);
	}

	public void highlight(String direction) {
		highlight(CardinalDirections.nameToDirection(direction));
	}

	private void init() {
		DialogPanel panel = new DialogPanel();
		setMainPanel(panel);
		panel.setPosition(new Point2D.Double(0.7, 0.6));
		// yeah, this is a hack to look as we have a square
		// - we know that the display will have 3:4 ratio
		panel.setSize(new Dimension2D_Double(0.3, 0.4));
		// transparent background and border
		panel.setBgColor(Color.WHITE);
		panel.setBorder(Color.BLACK);
		directions.setAction("DIRECTION");
		directions.addListener(new ClickListener());
		cds.setScale(new Dimension2D_Double(-1, -1));
		cds.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		cds.setImage(OTHER_PACKAGE + ".CardinalDirections");
		directions.addLayer(cds);
		hn.setScale(new Dimension2D_Double(-1, -1));
		hn.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		hn.setImage(OTHER_PACKAGE + ".hnorth");
		hn.setVisible(false);
		directions.addLayer(hn);
		hne.setScale(new Dimension2D_Double(-1, -1));
		hne.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		hne.setImage(OTHER_PACKAGE + ".hnortheast");
		hne.setVisible(false);
		directions.addLayer(hne);
		hnw.setScale(new Dimension2D_Double(-1, -1));
		hnw.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		hnw.setImage(OTHER_PACKAGE + ".hnorthwest");
		hnw.setVisible(false);
		directions.addLayer(hnw);
		hw.setScale(new Dimension2D_Double(-1, -1));
		hw.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		hw.setImage(OTHER_PACKAGE + ".hwest");
		hw.setVisible(false);
		directions.addLayer(hw);
		he.setScale(new Dimension2D_Double(-1, -1));
		he.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		he.setImage(OTHER_PACKAGE + ".heast");
		he.setVisible(false);
		directions.addLayer(he);
		hs.setScale(new Dimension2D_Double(-1, -1));
		hs.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		hs.setImage(OTHER_PACKAGE + ".hsouth");
		hs.setVisible(false);
		directions.addLayer(hs);
		hse.setScale(new Dimension2D_Double(-1, -1));
		hse.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		hse.setImage(OTHER_PACKAGE + ".hsoutheast");
		hse.setVisible(false);
		directions.addLayer(hse);
		hsw.setScale(new Dimension2D_Double(-1, -1));
		hsw.setSourcePart(new Rectangle2D.Double(0, 0, 0, 0));
		hsw.setImage(OTHER_PACKAGE + ".hsouthwest");
		hsw.setVisible(false);
		directions.addLayer(hsw);
		panel.addComponent(directions);
	}

	@Override
	public void insertTo(WorkingMemory workingMemory) {
		factDelegate.insertTo(workingMemory);
	}

	@Override
	public boolean isInserted() {
		return factDelegate.isInserted();
	}

	@Override
	public void retractFrom(WorkingMemory workingMemory) {
		factDelegate.retractFrom(workingMemory);
	}

	public void show(Player player, IPlayerCommunication playerCommunication) {
		direction = null;
		setTargetPlayer(player.getInGameName());
		playerCommunication.showDialog(this);
		update();
	}

	@Override
	public void update() {
		factDelegate.update();
	}
}
