package cz.cuni.amis.pogamut.edu.ut2004.agent;

import org.drools.WorkingMemory;

import cz.cuni.amis.pogamut.edu.agent.Player;
import cz.cuni.amis.pogamut.edu.ut2004.UT2004Scenario;
import cz.cuni.amis.pogamut.edu.ut2004.dialogs.CardinalDirectionsDialog;
import cz.cuni.amis.pogamut.edu.ut2004.dialogs.MapDialog;

/**
 * A player equipped with MapDialog and CardinalDirectionDialog.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class UT2004Player extends Player {

	protected MapDialog mapDialog;
	protected CardinalDirectionsDialog cdDialog;

	public UT2004Player(String name, String inGameName, UT2004Scenario scenario) {
		super(name, inGameName, scenario.getControlServer());
		mapDialog = new MapDialog(this, scenario, scenario.getMap().getData());
		cdDialog = new CardinalDirectionsDialog();
	}

	public MapDialog getMapDialog() {
		return mapDialog;
	}

	public CardinalDirectionsDialog getCardinalDirectionsDialog() {
		return cdDialog;
	}

	@Override
	public void insertTo(WorkingMemory workingMemory) {
		super.insertTo(workingMemory);
		mapDialog.insertTo(workingMemory);
		cdDialog.insertTo(workingMemory);
	}
}
