package cz.cuni.amis.pogamut.edu.ut2004;

import cz.cuni.amis.pogamut.edu.Scenario;
import cz.cuni.amis.pogamut.edu.ut2004.agent.UT2004Player;
import cz.cuni.amis.pogamut.edu.ut2004.controlserver.UT2004ControlServer;
import cz.cuni.amis.pogamut.edu.ut2004.dialogs.MapDialog;

/**
 * Simple derived class from Scenario. It instantiates the control server
 * and defines the distance considered as "nearby"
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public class UT2004Scenario extends Scenario {

	protected MapDialog mapDialog;

	public UT2004Scenario(String configFile) {
		super(configFile);
		UT2004ControlServer server = new UT2004ControlServer(this, getLogger());
		server.waitUntilPlayersConnect(minPlayers);
	}
	
	public UT2004Player getUT2004Player(String name) {
		return (UT2004Player) getPlayer(name);
	}

	@Override
	public double getNearbyDistance() {
		return 1000;
	}
}
