package cz.cuni.amis.pogamut.edu.timer;

import java.util.TimerTask;

import cz.cuni.amis.pogamut.edu.Scenario;
import cz.cuni.amis.pogamut.edu.drools.SimpleFact;

/**
 * The timer that is used in rules (DSL). Its value (time) is updated every
 * second. The task runs in different thread than where the rules are executed
 * and therefore it it synchronized.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class Timer extends SimpleFact {

	/**
	 * The task which increases the timer variable every second and updates the object.
	 * 
	 * @author Radim Vansa <radim.vansa@matfyz.cz>
	 * 
	 */
	private class UpdateTimerTask extends TimerTask {
		Timer timer;

		public UpdateTimerTask(Timer timer) {
			this.timer = timer;
		}

		@Override
		public void run() {
			this.timer.tick();
		}
	}

	protected boolean running;
	protected int time = 0;

	protected java.util.Timer timer = new java.util.Timer();

	public Timer(String name, Scenario scenario) {
		super(name);
		timer.scheduleAtFixedRate(new UpdateTimerTask(this), 1000, 1000);
		running = true;
	}

	public int getTime() {
		return time;
	}

	/**
	 * Returns the time value to 0 and restarts the task if it was stopped.
	 */
	public void restart() {
		this.time = 0;
		if (!running) {
			timer = new java.util.Timer();
			timer.scheduleAtFixedRate(new UpdateTimerTask(this), 1000, 1000);
		}
	}

	public void setTime(int time) {
		this.time = time;
	}

	/**
	 * Stops the timer.
	 */
	public void stop() {
		this.timer.cancel();
		this.running = false;
		time = 0;
	}

	protected void tick() {
		this.time++;
		update();
	}

}
