package cz.cuni.amis.pogamut.edu.map.marks;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.l10n.CannotTranslateException;
import cz.cuni.amis.pogamut.edu.l10n.ITranslator;
import cz.cuni.amis.pogamut.edu.map.MapData;

/**
 * One point in the path, just an AbstractPoint with defined writeXML method.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class PathPoint extends AbstractPoint {

	public PathPoint() {
	}

	public PathPoint(double x, double y) {
		setLocation(new Location(x, y, 0));
	}

	@Override
	public void writeXML(XMLStreamWriter writer, int indent,
			ITranslator translator) throws XMLStreamException {
		MapData.writeXMLIndent(writer, indent);
		String point = "point";
		try {
			point = translator.translateTo(point);
		} catch (CannotTranslateException e) {
		}
		writer.writeStartElement(point);
		writer.writeAttribute("x", String.valueOf(getLocation().getX()));
		writer.writeAttribute("y", String.valueOf(getLocation().getY()));
		MapData.writeXMLIndent(writer, indent);
		writer.writeEndElement();
	}
}
