package cz.cuni.amis.pogamut.edu.map.marks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import cz.cuni.amis.pogamut.edu.l10n.CannotTranslateException;
import cz.cuni.amis.pogamut.edu.l10n.ITranslator;
import cz.cuni.amis.pogamut.edu.map.MapData;
import cz.cuni.amis.pogamut.edu.utils.ColorTable;

/**
 * The path is a broken line displayed in the map dialog. It is formed from
 * several path points. The color and width of the line can be defined.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class Path extends AbstractMark {

	protected Color color = Color.RED;
	protected List<PathPoint> points = new ArrayList<PathPoint>();
	protected double width = 3;

	public void addPoint(PathPoint p) {
		points.add(p);
	}

	public Color getColor() {
		return color;
	}

	public int getNumPoints() {
		return points.size();
	}

	public PathPoint getPoint(int i) {
		return points.get(i);
	}

	public List<PathPoint> getPoints() {
		return Collections.unmodifiableList(points);
	}

	public double getWidth() {
		return width;
	}

	public PathPoint removePoint(int i) {
		return points.remove(i);
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public void setWidth(double width) {
		this.width = width;
	}

	@Override
	public void writeXML(XMLStreamWriter writer, int indent,
			ITranslator translator) throws XMLStreamException {
		MapData.writeXMLIndent(writer, indent);
		String path = "path";
		try {
			path = translator.translateTo(path);
		} catch (CannotTranslateException e) {
		}
		writer.writeStartElement(path);
		writer.writeAttribute("id", getName());
		writer.writeAttribute("width", String.valueOf(getWidth()));
		writer.writeAttribute("color", ColorTable.getNameFor(getColor()));
		for (PathPoint point : points) {
			point.writeXML(writer, indent + 1, translator);
		}
		MapData.writeXMLIndent(writer, indent);
		writer.writeEndElement();
	}

	public void removeAllPoints() {
		points.clear();
	}
}
