package cz.cuni.amis.pogamut.edu.map.marks;

import java.awt.Color;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import cz.cuni.amis.pogamut.edu.l10n.CannotTranslateException;
import cz.cuni.amis.pogamut.edu.l10n.ITranslator;
import cz.cuni.amis.pogamut.edu.map.MapData;
import cz.cuni.amis.pogamut.edu.utils.ColorTable;

/**
 * Point of interest - point marked in the map. Its symbol, description and their
 * colour can be defined.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public class POI extends AbstractPoint {
	
	public enum Symbol {
		NONE,
		CIRCLE,
		STAR,
		RECT,
		HOUSE		
	}

	protected Symbol symbol = Symbol.CIRCLE;
	protected String description;
	protected Color color = Color.RED;

	public POI() {
		super();
	}
	
	public POI(String id) {
		super(id);
	}

	public Color getColor() {
		return color;
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	@Override
	public void writeXML(XMLStreamWriter writer, int indent,
			ITranslator translator) throws XMLStreamException {
		MapData.writeXMLIndent(writer, indent);
		writer.writeStartElement("POI");
		writer.writeAttribute("x", String.valueOf(location.getX()));
		writer.writeAttribute("y", String.valueOf(location.getY()));
		writer.writeAttribute("z", String.valueOf(location.getZ()));
		writer.writeAttribute("id", getName());
		try {
			writer.writeAttribute("symbol", translator.translateTo(symbol.toString()));
		} catch (CannotTranslateException e) {
			writer.writeAttribute("symbol", symbol.toString());
		}
		writer.writeAttribute("description", description);
		String colorName = ColorTable.getNameFor(color);
		try {
			writer.writeAttribute("color", translator.translateTo(colorName));
		} catch (CannotTranslateException e) {
			writer.writeAttribute("color", colorName);
		}
		MapData.writeXMLIndent(writer, indent);
		writer.writeEndElement();		
	}

	public Symbol getSymbol() {
		return symbol;
	}

	public void setSymbol(Symbol symbol) {
		this.symbol = symbol;
	}
}
