package cz.cuni.amis.pogamut.edu.map.areas;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.Scenario;
import cz.cuni.amis.pogamut.edu.drools.Rule;
import cz.cuni.amis.pogamut.edu.drools.RulesPackage;
import cz.cuni.amis.pogamut.edu.l10n.ITranslator;
import cz.cuni.amis.pogamut.edu.utils.IProvisory;
import cz.cuni.amis.pogamut.edu.utils.IRescaler;

/**
 * This class is covers a complex area and holds references to other areas.
 * These are not included in the map and at some moment they will be the regular
 * reference to them lost. But they still have their rules registered and are in
 * the working memory. We should remove them.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class ProvisoryProxy extends AbstractComplexArea implements
		IComplexArea, IProvisory {

	protected List<IArea> maintained = new ArrayList<IArea>();
	protected IArea covering;
	protected int linkCount = 0;
	protected Scenario scenario;
	
	public ProvisoryProxy(IArea area, Scenario scenario) {
		this.scenario = scenario;
		this.covering = area;
	}

	@Override
	public void increaseLinkCount() {
		++linkCount;
	}

	/**
	 * If the link count goes to zero it removes the rules and retracts the held
	 * areas from working memory.
	 */
	@Override
	public void decreaseLinkCount() {
		--linkCount;
		if (linkCount == 0) {
			for (IArea a  : maintained) {
				if (a instanceof IComplexArea) {
					((IComplexArea) a).removeRules();
				}
				a.retractFrom(scenario.getWorkingMemory());
				if (a instanceof IProvisory) {
					((IProvisory) a).decreaseLinkCount();
				}
			}
			// it is probably already retracted, but...
			retractFrom(scenario.getWorkingMemory());
		}
	}

	public void addMaintained(IArea a) {
		maintained.add(a);
	}

	@Override
	public boolean containsExactly(IArea area) {
		if (covering instanceof IComplexArea) {
			return ((IComplexArea) covering).containsExactly(area);
		} else {
			return covering.equals(area);
		}
	}

	public IArea getCoveredArea() {
		return covering;
	}

	@Override
	public void generateRules(RulesPackage rulesPackage) {
		if (!this.generatedRules.isEmpty()) {
			return;
		}
		this.pkg = rulesPackage;
		if (covering instanceof IComplexArea) {
			((IComplexArea) covering).generateRules(rulesPackage);
		}
		Rule r1 = new Rule();
		r1.addAttribute("salience 1003");
		r1.addCondition("$a: cz.cuni.amis.pogamut.edu.agent.Agent()");
		r1
			.addCondition("cz.cuni.amis.pogamut.edu.map.areas.IArea(name == \""
					+ covering.getName() + "\", agents contains $a)");
		r1
			.addCondition("$m: cz.cuni.amis.pogamut.edu.map.areas.ProvisoryProxy(name == \""
					+ this.getName() + "\", agents not contains $a)");
		r1.addConsequence("$m.addAgent($a, scenario.getMark());");
		rulesPackage.addRule(r1);
		generatedRules.add(r1);
		Rule r2 = new Rule();
		r2.addAttribute("salience 1002");
		r2.addCondition("$a: cz.cuni.amis.pogamut.edu.agent.Agent()");
		r2
			.addCondition("$m: cz.cuni.amis.pogamut.edu.map.areas.ProvisoryProxy(name == \""
					+ this.getName() + "\", agents contains $a)");
		r2
			.addCondition("cz.cuni.amis.pogamut.edu.map.areas.IArea(name == \""
					+ covering.getName() + "\", agents not contains $a)");
		r2.addConsequence("$m.removeAgent($a, scenario.getMark());");
		rulesPackage.addRule(r2);
		generatedRules.add(r2);
	}

	@Override
	public void removeRules() {
		super.removeRules();
		if (covering instanceof IComplexArea) {
			((IComplexArea) covering).removeRules();
		}
	}

	/**
	 * If the added is another IProvisory, we should increase its link count to
	 * prevent the destruction.
	 */
	@Override
	public void add(IArea area) {
		((IComplexArea) covering).add(area);
		if (area instanceof IProvisory) {
			((IProvisory) area).increaseLinkCount();
			// number of insertions and link count should be the same
			area.insertTo(scenario.getWorkingMemory());
			// simple areas are not provisory but for the case...
			if (area instanceof IComplexArea) {
				addMaintained((IComplexArea) area);
			}
		}
	}

	/**
	 * See add for details.
	 */
	@Override
	public void remove(IArea area) {
		((IComplexArea) covering).remove(area);
		if (area instanceof IProvisory) {
			((IProvisory) area).decreaseLinkCount();
		}
	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof ProvisoryProxy) {
			return covering.equals(((ProvisoryProxy) o).covering);
		} else {
			return covering.equals(o);
		}
	}

	@Override
	public boolean contains(Location location, boolean ignoreZCoord) {
		return covering.contains(location, ignoreZCoord);
	}

	@Override
	public Rectangle2D getBounds() {
		return covering.getBounds();
	}

	@Override
	public Location getCenter() {
		return covering.getCenter();
	}

	@Override
	public PolygonArea getPolygonArea() {
		return covering.getPolygonArea();
	}

	@Override
	public void rescale(IRescaler rescaler) {
		covering.rescale(rescaler);
	}

	@Override
	public void writeXML(XMLStreamWriter writer, int indent,
			ITranslator translator) throws XMLStreamException {
		throw new UnsupportedOperationException("Cannot store provisory area.");
	}
}
