package cz.cuni.amis.pogamut.edu.map.areas;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.drools.Rule;
import cz.cuni.amis.pogamut.edu.drools.RulesPackage;
import cz.cuni.amis.pogamut.edu.l10n.CannotTranslateException;
import cz.cuni.amis.pogamut.edu.l10n.ITranslator;
import cz.cuni.amis.pogamut.edu.map.MapData;
import cz.cuni.amis.pogamut.edu.utils.IRescaler;

/**
 * This area is formed by intersection of subareas.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public class IntersectArea extends AbstractComplexArea implements
		IIntersectArea {

	protected ArrayList<IArea> areas = new ArrayList<IArea>();
	protected PolygonArea polyCache = null;

	public IntersectArea() {
	}

	public IntersectArea(IArea a1, IArea a2) {
		if (a1 == null || a2 == null) {
			throw new IllegalArgumentException("Area cannot be null.");
		}
		add(a1);
		add(a2);
	}

	public void add(IArea area) {
		areas.add(area);
		polyCache = null;
	}

	@Override
	public boolean contains(Location p, boolean ignoreZCoord) {
		for (IArea a : areas) {
			if (!a.contains(p, ignoreZCoord)) {
				return false;
			}
		}
		return true;
	}

	@Override
	public boolean containsExactly(IArea area) {
		for (IArea a : areas) {
			if (a.equals(area)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public Rectangle2D getBounds() {
		Rectangle2D rect = new Rectangle();
		for (IArea a : areas) {
			Rectangle.union(rect, a.getBounds(), rect);
		}
		return rect;
	}

	@Override
	public void generateRules(RulesPackage pkg) {
		if (!this.generatedRules.isEmpty()) {
			return;
		}
		this.pkg = pkg;
		Rule r1 = new Rule();
		r1.addAttribute("salience 2");
		r1.addCondition("$a: cz.cuni.amis.pogamut.edu.agent.Agent()");

		for (IArea a : areas) {
			r1
				.addCondition("cz.cuni.amis.pogamut.edu.map.areas.IArea(name == \""
						+ a.getName() + "\", agents contains $a)");

			Rule r2 = new Rule();
			r2.addAttribute("salience 1");
			r2.addCondition("$a: cz.cuni.amis.pogamut.edu.agent.Agent()");
			r2
				.addCondition("cz.cuni.amis.pogamut.edu.map.areas.IArea(name == \""
						+ a.getName() + "\", agents not contains $a)");
			r2
				.addCondition("$m: cz.cuni.amis.pogamut.edu.map.areas.IntersectArea(name == \""
						+ this.getName() + "\", agents contains $a)");
			// r2.addConsequence("System.out.println(\"remove at " +
			// r2.getName() + "\");");
			r2.addConsequence("$m.removeAgent($a, scenario.getMark());");
			pkg.addRule(r2);
			generatedRules.add(r2);

			if (a instanceof IComplexArea) {
				((IComplexArea) a).generateRules(pkg);
			}
		}
		r1
			.addCondition("$m: cz.cuni.amis.pogamut.edu.map.areas.IntersectArea(name == \""
					+ this.getName() + "\", agents not contains $a)");
		r1.addConsequence("$m.addAgent($a, scenario.getMark());");
		// r1.addConsequence("System.out.println(\"add at " + r1.getName() +
		// "\");");
		pkg.addRule(r1);
		generatedRules.add(r1);
	}

	@Override
	public Location getCenter() {
		Location l = new Location(0, 0, 0);
		for (IArea a : areas) {
			l.add(a.getCenter());
		}
		return l.scale(1 / ((double) areas.size()));
	}

	@Override
	public PolygonArea getPolygonArea() {
		if (polyCache == null) {
			polyCache = new PolygonArea();
			polyCache.setToUniverse();
			for (IArea a : areas) {
				polyCache.intersect(a.getPolygonArea());
			}
		}
		return polyCache;
	}

	@Override
	public void writeXML(XMLStreamWriter writer, int indent,
			ITranslator translator) throws XMLStreamException {
		MapData.writeXMLIndent(writer, indent);
		try {
			writer.writeStartElement(translator.translateTo("intersection"));
		} catch (CannotTranslateException e) {
			writer.writeStartElement("intersection");
		}
		writer.writeAttribute("id", getName());
		for (IArea area : areas) {
			area.writeXML(writer, indent + 1, translator);
		}
		MapData.writeXMLIndent(writer, indent);
		writer.writeEndElement();
	}

	@Override
	public void remove(IArea area) {
		areas.remove(area);
		polyCache = null;
	}

	@Override
	public void rescale(IRescaler rescaler) {
		polyCache = null;
	}

	public List<IArea> getAreas() {
		return areas;
	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof IntersectArea) {
			return areas.containsAll(((IntersectArea) o).areas)
					&& ((IntersectArea) o).areas.containsAll(areas);
		} else {
			return false;
		}
	}

}
