package cz.cuni.amis.pogamut.edu.map.areas;

import cz.cuni.amis.pogamut.edu.map.exceptions.AreaException;

/**
 * As the ICompoundArea is union, this is the intersection of
 * more sub-areas - the point has to be in all of them to be also
 * here.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public interface IIntersectArea extends IComplexArea {
	
	/**
	 * Adds some area to the intersection
	 * 
	 * @param area
	 * @throws AreaException
	 */
	public void add(IArea area);
}
