package cz.cuni.amis.pogamut.edu.map.areas;

import java.util.List;

import cz.cuni.amis.pogamut.edu.map.exceptions.AreaException;

/**
 * This area should be union of multiple sub-areas, with exception of some
 * excluded area.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface ICompoundArea extends IComplexArea {

	/**
	 * Adds an area to the union
	 * 
	 * @param area
	 */
	public void add(IArea area);

	/**
	 * Adds an area to excluded part
	 * 
	 * @param area
	 */
	public void exclude(IArea area);

	/**
	 * 
	 * @return the excluded area
	 */
	public ICompoundArea getExcludedArea();

	/**
	 * Getter for the type of the area - e.g. district, street, house...
	 * 
	 * @return
	 */
	public String getType();

	/**
	 * Removes the area from excluded part
	 * 
	 * @param area
	 * @throws AreaException
	 */
	public void reinclude(IArea area);

	/**
	 * Removes the area from the union
	 * 
	 * @param area
	 * @throws AreaException
	 */
	public void remove(IArea area);

	/**
	 * Sets the whole excluded area
	 * 
	 * @param complexArea
	 * @throws AreaException
	 */
	public void setExcludedArea(ICompoundArea complexArea) throws AreaException;

	/**
	 * Setter for the type of the area - e.g. district, street, house...
	 * 
	 * @return
	 */
	public void setType(String type);

	/**
	 * Returns a list of all subareas contained in this area.
	 * 
	 * @return
	 */
	public List<IArea> getSubareas();
}
