package cz.cuni.amis.pogamut.edu.map.areas;

import cz.cuni.amis.pogamut.edu.drools.RulesPackage;

/**
 * Interface for all areas that are somehow collecting more areas
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface IComplexArea extends IArea {

	/**
	 * Adds some area to this complex area
	 * 
	 * @param area
	 */
	public void add(IArea area);

	/**
	 * If this area generates some extra rules (from their data structure), it
	 * should be done in this method. All the generated rules should be added
	 * into specified package.
	 * 
	 * @param rulesPackage
	 */
	public void generateRules(RulesPackage rulesPackage);

	/**
	 * Tests whether one of the sub-areas is specified area
	 * 
	 * @param area
	 * @return
	 */
	public boolean containsExactly(IArea area);

	/**
	 * Removes some area from this complex area.
	 * 
	 * @param area
	 */
	public void remove(IArea area);

	/**
	 * Removes the generated rules
	 */
	public void removeRules();

}
