package cz.cuni.amis.pogamut.edu.map.areas;

import java.awt.geom.Rectangle2D;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.drools.Rule;
import cz.cuni.amis.pogamut.edu.drools.RulesPackage;
import cz.cuni.amis.pogamut.edu.l10n.ITranslator;
import cz.cuni.amis.pogamut.edu.utils.IProvisory;
import cz.cuni.amis.pogamut.edu.utils.IRescaler;

/**
 * This class deputizes another area but uses it's own name.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public class AliasArea extends AbstractComplexArea implements IProvisory {

	protected IArea covering;
	protected int linkCount = 0;
	
	public AliasArea(IArea covering) {
		this.covering = covering;
	}
	
	@Override
	public boolean contains(Location location, boolean ignoreZCoord) {
		return covering.contains(location, ignoreZCoord);
	}

	@Override
	public Rectangle2D getBounds() {
		return covering.getBounds();
	}

	@Override
	public Location getCenter() {
		return covering.getCenter();
	}

	@Override
	public PolygonArea getPolygonArea() {
		return covering.getPolygonArea();
	}

	@Override
	public void rescale(IRescaler rescaler) {
		covering.rescale(rescaler);
	}

	@Override
	public void writeXML(XMLStreamWriter writer, int indent,
			ITranslator translator) throws XMLStreamException {
		covering.writeXML(writer, indent, translator);
	}

	@Override
	public void add(IArea area) {
		if (covering instanceof IComplexArea) {
			((IComplexArea)covering).add(area);
		} else {
			throw new IllegalStateException();
		}
	}

	@Override
	public boolean containsExactly(IArea area) {
		return area == covering;
	}

	@Override
	public void generateRules(RulesPackage rulesPackage) {
		if (!this.generatedRules.isEmpty()) {
			return;
		}
		this.pkg = rulesPackage;
		if (covering instanceof IComplexArea) {
			((IComplexArea)covering).generateRules(rulesPackage);
		}
		Rule r1 = new Rule();
		r1.addAttribute("salience 1003");
		r1.addCondition("$a: cz.cuni.amis.pogamut.edu.agent.Agent()");
		r1
			.addCondition("cz.cuni.amis.pogamut.edu.map.areas.IArea(name == \""
					+ covering.getName() + "\", agents contains $a)");
		r1
			.addCondition("$m: cz.cuni.amis.pogamut.edu.map.areas.AliasArea(name == \""
					+ this.getName() + "\", agents not contains $a)");
		r1.addConsequence("$m.addAgent($a, scenario.getMark());");
		rulesPackage.addRule(r1);
		generatedRules.add(r1);
		Rule r2 = new Rule();
		r2.addAttribute("salience 1002");
		r2.addCondition("$a: cz.cuni.amis.pogamut.edu.agent.Agent()");
		r2
			.addCondition("$m: cz.cuni.amis.pogamut.edu.map.areas.AliasArea(name == \""
					+ this.getName() + "\", agents contains $a)");
		r2
			.addCondition("cz.cuni.amis.pogamut.edu.map.areas.IArea(name == \""
					+ covering.getName() + "\", agents not contains $a)");
		r2.addConsequence("$m.removeAgent($a, scenario.getMark());");
		rulesPackage.addRule(r2);
		generatedRules.add(r2);
	}

	@Override
	public void remove(IArea area) {
		if (covering instanceof IComplexArea) {
			((IComplexArea)covering).remove(area);
		} else {
			throw new IllegalStateException();
		}
	}

	@Override
	public void decreaseLinkCount() {
		--linkCount;
		if (linkCount <= 0) {
			removeRules();
		}
	}

	@Override
	public void increaseLinkCount() {
		++linkCount;		
	}

}
