package cz.cuni.amis.pogamut.edu.map.areas;

import java.util.ArrayList;
import java.util.List;

import cz.cuni.amis.pogamut.edu.drools.Rule;
import cz.cuni.amis.pogamut.edu.drools.RulesPackage;

/**
 * This class manages the rules removal (the generating is dependent on the
 * derived class).
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public abstract class AbstractComplexArea extends AbstractArea implements
		IComplexArea {

	protected List<Rule> generatedRules = new ArrayList<Rule>();
	protected RulesPackage pkg;

	public AbstractComplexArea() {
	}

	public AbstractComplexArea(String name) {
		super(name);
	}

	@Override
	public void removeRules() {
		for (Rule rule : generatedRules) {
			pkg.removeRule(rule);
		}
		generatedRules.clear();
	}

}
