package cz.cuni.amis.pogamut.edu.map.areas;

import java.util.HashSet;
import java.util.Set;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.edu.agent.Agent;
import cz.cuni.amis.pogamut.edu.drools.SimpleFact;

/**
 * The basic functions of all areas - registration of agents, superior areas and
 * such.
 * Sometimes are the addAgent and removeAgent called in the same rule loop cycle
 * but we do not know the order or number of calls. In such occasions has the
 * addAgent call priority. It is achieved by using the mark - in each cycle is for 
 * for each agent used increasing number. If the removal has lesser number than the
 * last adding it will be not performed.
 * The forceRemoveAgent method works always.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public abstract class AbstractArea extends SimpleFact implements IArea,
		Cloneable {
	protected Set<Agent> agents = new HashSet<Agent>();
	protected long mark;
	protected IComplexArea superior;

	public AbstractArea() {
	}

	public AbstractArea(String name) {
		super(name);
	}

	public void addAgent(Agent agent, long mark) {
		this.mark = mark;
		if (!this.agents.contains(agent)) {
			this.agents.add(agent);
			update();
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public Object clone() throws CloneNotSupportedException {
		AbstractArea aa = (AbstractArea) super.clone();
		aa.agents = (Set<Agent>) ((HashSet) this.agents).clone();
		return aa;
	}

	public void forceRemoveAgent(Agent agent) {
		this.agents.remove(agent);
		update();
	}

	public Set<Agent> getAgents() {
		return this.agents;
	}

	public Location getLocation() {
		return getCenter();
	}

	@Override
	public double getSurface() {
		return this.getPolygonArea().getSurface();
	}

	public IComplexArea getSuperior() {
		return superior;
	}

	public boolean hasContact(IArea area) {
		return PolygonArea.haveContact(this.getPolygonArea(),
			area.getPolygonArea());
	}

	public void removeAgent(Agent agent, long mark) {
		if (this.mark < mark) {
			this.mark = mark;
			if (this.agents.remove(agent)) {
				update();
			}
		}
	}

	public void setSuperior(IComplexArea superior) {
		this.superior = superior;
	}
}
