package cz.cuni.amis.pogamut.edu.map;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import cz.cuni.amis.pogamut.edu.l10n.ITranslator;

/**
 * The base class of areas and marks - anything that can be written into the map
 * file.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface IMapDataUnit {
	/**
	 * This method is called to let the object write it's contents into XML
	 * file.
	 * 
	 * @param writer
	 * @param intent -
	 *            used for correct indentation
	 * @param translator
	 */
	public void writeXML(XMLStreamWriter writer, int indent,
			ITranslator translator) throws XMLStreamException;
}
