package cz.cuni.amis.pogamut.edu.logging;

/**
 * Scores are simple players' ratings - the player can get bonuses or penalties
 * for different actions.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class Score {
	protected int penalties;
	protected int bonuses;

	public void addPenalty(int penalty) {
		this.penalties += penalty;
	}

	public void addBonus(int bonus) {
		this.bonuses += bonus;
	}

	public int getPenalties() {
		return this.penalties;
	}

	public int getBonuses() {
		return this.bonuses;
	}

	public int getTotal() {
		return this.bonuses - this.penalties;
	}

	@Override
	public String toString() {
		return "Penalties: " + penalties + " points, Bonuses: " + bonuses
				+ " points, Total: " + (bonuses - penalties) + " points";
	}
}
