package cz.cuni.amis.pogamut.edu.logging;

import java.util.ArrayList;

import cz.cuni.amis.pogamut.edu.Scenario;
import cz.cuni.amis.pogamut.edu.utils.NamedObject;

/**
 * Reports concentrate data about particular event. They are joined together in
 * records - each record contains title (description of the record) and its data -
 * some note, time, place etc.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class Report extends NamedObject {
	protected ArrayList<Pair> data = new ArrayList<Pair>();

	protected class Pair {

		String title;
		Object data;

		public Pair(String title, Object data) {
			this.title = title;
			this.data = data;
		}

	}

	public Report(String name) {
		super(name);
	}

	public void add(String title, Object data) {
		this.data.add(new Pair(title, data));
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(getName());
		sb.append(":\n");
		for (Pair p : data) {
			sb.append(p.title == null ? "-invalid title-" : p.title);
			sb.append(":\t");
			sb.append(p.data == null ? "-invalid data-" : p.data.toString());
			sb.append("\n");
		}
		return sb.toString();
	}

	public void store(Scenario scenario) {
		scenario.addReport(this);
	}
}
