package cz.cuni.amis.pogamut.edu.logging;

import java.util.logging.Level;

/*!
 * Just a wrapper - will be substituted in future 
 */
public class Logger {
	public void log(Level level, String msg) {
		log(level, msg, new Object[0]);
	}
	
	public void log(Level level, String msg, Object param) {
		log(level, msg, new Object[]{param});
	}
	
	public void log(Level level, String msg, Object[] params) {
		System.err.println(level.getLocalizedName() + ": " + msg);
		for (Object o: params) {
			System.err.println(o.toString());
		}
	}
	
	public void finest(String msg) {
		log(Level.FINEST, msg);
	}
	
	public void finest(String msg, Object param) {
		log(Level.FINEST, msg, param);
	}
	
	public void finest(String msg, Object[] params) {
		log(Level.FINEST, msg, params);
	}
	
	public void finer(String msg) {
		log(Level.FINER, msg);
	}
	
	public void finer(String msg, Object param) {
		log(Level.FINER, msg, param);
	}
	
	public void finer(String msg, Object[] params) {
		log(Level.FINER, msg, params);
	}
	
	public void fine(String msg) {
		log(Level.FINE, msg);
	}
	
	public void fine(String msg, Object param) {
		log(Level.FINE, msg, param);
	}
	
	public void fine(String msg, Object[] params) {
		log(Level.FINE, msg, params);
	}
	
	public void info(String msg) {
		log(Level.INFO, msg);
	}
	
	public void info(String msg, Object param) {
		log(Level.INFO, msg, param);
	}
	
	public void info(String msg, Object[] params) {
		log(Level.INFO, msg, params);
	}
	
	public void warning(String msg) {
		log(Level.WARNING, msg);
	}
	
	public void warning(String msg, Object param) {
		log(Level.WARNING, msg, param);
	}
	
	public void warning(String msg, Object[] params) {
		log(Level.WARNING, msg, params);
	}
	
	public void severe(String msg) {
		log(Level.SEVERE, msg);
	}
	
	public void severe(String msg, Object param) {
		log(Level.SEVERE, msg, param);
	}
	
	public void severe(String msg, Object[] params) {
		log(Level.SEVERE, msg, params);
	}

}
