package cz.cuni.amis.pogamut.edu.l10n;

/**
 * This factory produces objects that are able to translate phrases from and to
 * english.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class TranslatorFactory {

	/*
	 * To prohibit instantiation
	 */
	private TranslatorFactory() {

	}

	/**
	 * Creates the translator for specified language.
	 * 
	 * @param language
	 * @return
	 * @throws NotSupportedLanguageException
	 *             if the language is not known.
	 */
	public static ITranslator createTranslator(String language)
			throws NotSupportedLanguageException {
		if (language.equalsIgnoreCase("english")) {
			return new EnglishTranslator();
		} else if (language.equalsIgnoreCase("czech")) {
			return new CzechTranslator();
		}
		throw new NotSupportedLanguageException();
	}
}
