package cz.cuni.amis.pogamut.edu.l10n;

/**
 * Interface from translating of words and phrases.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface ITranslator {

	/**
	 * Translates the word or phrase from english to the translator's language.
	 * 
	 * @param phrase
	 * @return
	 * @throws CannotTranslateException
	 *             when the phrase is unknown.
	 */
	public String translateTo(String phrase) throws CannotTranslateException;

	/**
	 * Translates the word or phrase from the translator's language to english.
	 * 
	 * @param phrase
	 * @return
	 * @throws CannotTranslateException
	 *             when the phrase is unknown.
	 */
	public String translateFrom(String phrase) throws CannotTranslateException;
}
