package cz.cuni.amis.pogamut.edu.l10n;

import java.util.HashMap;
import java.util.Map;

/**
 * Stub of Czech dictionary
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class CzechTranslator implements ITranslator {

	protected static Map<String, String> dictionaryTo = new HashMap<String, String>();
	protected static Map<String, String> dictionaryFrom = new HashMap<String, String>();

	static {
		addToDictionary("map", "mapa");
		addToDictionary("street", "ulice");
		addToDictionary("building", "budova");
		addToDictionary("square", "namesti");
		addToDictionary("square", "nmst");
	}

	protected static void addToDictionary(String from, String to) {
		if (!dictionaryTo.containsKey(from)) {
			dictionaryTo.put(from, to);
		}
		if (!dictionaryFrom.containsKey(to)) {
			dictionaryFrom.put(to, from);
		}
	}

	public String translateFrom(String phrase) throws CannotTranslateException {
		String trans = dictionaryFrom.get(phrase);
		if (trans == null) {
			throw new CannotTranslateException(phrase);
		} else {
			return trans;
		}
	}

	public String translateTo(String phrase) throws CannotTranslateException {
		String trans = dictionaryTo.get(phrase);
		if (trans == null) {
			throw new CannotTranslateException(phrase);
		} else {
			return trans;
		}
	}

}
