package cz.cuni.amis.pogamut.edu.drools;

import org.drools.WorkingMemory;

import cz.cuni.amis.pogamut.edu.utils.NamedObject;

/**
 * This class handles inserting of object into working memory, updating and
 * retracting. It assumes that this object will be in only one working memory at
 * a time.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public abstract class SimpleFact extends NamedObject implements IFact,
		Cloneable {

	private SimpleFactDelegate delegate = new SimpleFactDelegate(this);
	
	/**
	 * Create new fact with generated name
	 */
	public SimpleFact() {

	}

	/**
	 * Create new fact with specified name
	 * 
	 * @param name
	 */
	public SimpleFact(String name) {
		super(name);
	}

	/**
	 * Clone this object, inserting the new copy into working memory of its
	 * origin (if the origin is in any working memory)
	 */
	@Override
	public Object clone() throws CloneNotSupportedException {
		SimpleFact fact = (SimpleFact) super.clone();
		fact.delegate = new SimpleFactDelegate(fact);
		if (this.delegate.getWorkingMemory() != null) {
			fact.delegate.insertTo(this.delegate.getWorkingMemory());
		}
		return fact;
	}

	protected WorkingMemory getWorkingMemory() {
		return delegate.getWorkingMemory();
	}
	
	@Override
	public boolean isInserted() {
		return delegate.isInserted();
	}
	
	@Override
	public void insertTo(WorkingMemory workingMemory) {
		delegate.insertTo(workingMemory);
	}

	@Override
	public void retractFrom(WorkingMemory workingMemory) {
		delegate.retractFrom(workingMemory);
	}

	@Override
	public void update() {
		delegate.update();
	}

	
}
