package cz.cuni.amis.pogamut.edu.drools;

import cz.cuni.amis.pogamut.edu.utils.NamedObject;

/**
 * This class is used for runtime generation of rules. It stores all data for
 * one rule. It must be inserted into the RulesPackage to be compiled.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class Rule extends NamedObject {

	StringBuilder attributes = new StringBuilder();
	StringBuilder conditions = new StringBuilder();
	StringBuilder consequences = new StringBuilder();

	/**
	 * Create rule with generated name
	 */
	public Rule() {
	}

	/**
	 * Create rule with specified name
	 * 
	 * @param name
	 */
	public Rule(String name) {
		super(name);
	}

	/**
	 * Adds an attribute as salience, no-loop etc
	 * 
	 * @param attribute
	 */
	public void addAttribute(String attribute) {
		attributes.append(attribute);
		attributes.append('\n');
	}

	/**
	 * Adds one row of conditions
	 * 
	 * @param condition
	 */
	public void addCondition(String condition) {
		conditions.append(condition);
		conditions.append('\n');
	}

	/**
	 * Adds one row of consequences
	 * 
	 * @param consequence
	 */
	public void addConsequence(String consequence) {
		consequences.append(consequence);
		consequences.append('\n');
	}

	/**
	 * Returns string with whole rule, e.g.
	 * 
	 * <pre>
	 * rule &quot;my rule&quot;
	 *     salience 42
	 *     when
	 *         Foo(bar == &quot;foobar&quot;)
	 *         Goo(var == &quot;goovar&quot;)
	 *     then
	 *         System.out.print(&quot;Foobar and goovar!&quot;);
	 * end
	 * </pre>
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("rule \"");
		sb.append(this.getName());
		sb.append("\"\n");
		sb.append(attributes.toString());
		sb.append("when\n");
		sb.append(conditions.toString());
		sb.append("then\n");
		sb.append(consequences.toString());
		sb.append("end\n");
		return sb.toString();
	}
}
