package cz.cuni.amis.pogamut.edu.drools;

import org.drools.WorkingMemory;

/**
 * Interface for all facts. In general case can the fact be in multiple working
 * memories at one moment.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public interface IFact {

	/**
	 * Inserts the fact into working memory
	 * 
	 * @param workingMemory
	 */
	public void insertTo(WorkingMemory workingMemory);

	/**
	 * Returns true if the fact is inserted in any workingMemory
	 * 
	 * @return
	 */
	public boolean isInserted();

	/**
	 * Retracts the fact from working memory
	 * 
	 * @param workingMemory -
	 *            if null, the fact will be retracted from all working memories
	 */
	public void retractFrom(WorkingMemory workingMemory);

	/**
	 * Updates the fact in all working memories
	 */
	public void update();
}
